/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminCommon;
import filenet.vw.toolkit.admin.result.VWAdminConfirmWithCheckBoxDialog;
import filenet.vw.toolkit.admin.result.VWAdminConfirmYesNoCancelDialog;
import filenet.vw.toolkit.admin.result.VWAdminDataObjForTrackers;
import filenet.vw.toolkit.admin.result.VWAdminErrorDataObj;
import filenet.vw.toolkit.admin.result.VWAdminErrorsDialog;
import filenet.vw.toolkit.admin.result.VWAdminItemInList;
import filenet.vw.toolkit.admin.result.VWAdminManageTrackerErrorDialog;
import filenet.vw.toolkit.admin.result.VWAdminManageTrackersDialog;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminTrackerDataObject;
import filenet.vw.toolkit.admin.result.VWAdminWFByWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

public class VWAdminManageTrackers {
    private ListSelectionModel m_listSelectionModel = null;
    private VWTable m_resultsTable;
    private VWAdminResultTableModelBase m_tableModel;
    private int[] m_selectedRows;
    private int[] m_selectedCols;
    private Frame m_parentFrame = null;
    private Container m_mainContainer = null;
    private VWParticipant m_logonUser = null;
    private VWAdminManageTrackersDialog m_manageTrackersDialog = null;
    private Vector m_vWorkflows = new Vector();
    private VWAdminItemInList[] m_selectedTrackers = null;
    private Vector m_removeTrackersList = new Vector();
    private Vector m_wobsList = new Vector();
    private Vector m_vDelayWobsList = new Vector();
    private Vector m_vErrors = new Vector();
    private VWSession m_session = null;
    private VWAdminResultPane m_resultsPane = null;
    private boolean m_bOverride = false;

    public VWAdminManageTrackers(VWAdminResultPane resultsPane) {
        boolean bContinued;
        this.m_logonUser = resultsPane.getLogonUser();
        this.m_tableModel = resultsPane.getTableModel();
        this.m_resultsTable = resultsPane.getResultsTable();
        this.m_listSelectionModel = this.m_resultsTable.getSelectionModel();
        this.m_selectedRows = resultsPane.getSelectedRows();
        this.m_session = resultsPane.getSession();
        this.m_resultsPane = resultsPane;
        if (this.m_logonUser == null) {
            JOptionPane.showMessageDialog(resultsPane.getParentFrame(), VWResource.s_undeterminedLogonUser, VWResource.s_manageTrackersTitle, 1, null);
            return;
        }
        if (this.m_resultsTable.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(resultsPane.getParentFrame(), VWResource.s_noRowSelected, VWResource.s_manageTrackersTitle, 1, null);
            return;
        }
        this.m_wobsList = this.buildWobsList(this.m_selectedRows);
        if (this.m_vDelayWobsList.size() > 0 && !(bContinued = this.displayErrorMessages())) {
            return;
        }
        boolean bCancel = this.checkForSaveAndOverride(this.m_selectedRows);
        if (bCancel) {
            this.removeReferences();
            return;
        }
        this.m_manageTrackersDialog = new VWAdminManageTrackersDialog(resultsPane, this.m_wobsList);
        this.m_manageTrackersDialog.setVisible(true);
        boolean b_cancel = this.m_manageTrackersDialog.getStatus();
        if (b_cancel) {
            this.removeReferences();
            return;
        }
        this.m_vWorkflows = this.m_manageTrackersDialog.getWorkflowDataObjects();
        this.m_selectedTrackers = this.m_manageTrackersDialog.getSelectedTrackers();
        this.AddRemoveTrackers();
        for (int i = 0; i < this.m_vWorkflows.size(); ++i) {
            VWAdminWorkObjectTableData woData = ((VWAdminDataObjForTrackers)this.m_vWorkflows.elementAt(i)).getWoData();
            woData.resetChildren();
        }
        this.m_tableModel.removeWorkObjectsOutOfTable();
        this.m_tableModel.refreshAllRows();
        if (this.m_vErrors.size() != 0) {
            VWAdminErrorsDialog errDlg = new VWAdminErrorsDialog(resultsPane.getParentFrame(), VWResource.s_manageTrackersTitle, VWResource.s_manageTrackersErr, this.m_vErrors);
            errDlg.setVisible(true);
        }
        this.removeReferences();
    }

    private Vector buildWobsList(int[] rows) {
        Vector<VWAdminWorkObjectTableData> wobsList = new Vector<VWAdminWorkObjectTableData>();
        Vector<VWAdminWorkObjectTableData> v_delayWobsList = new Vector<VWAdminWorkObjectTableData>();
        try {
            int i;
            for (i = 0; i < rows.length; ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(rows[i]);
                VWWorkObject wob = woData.getWob();
                if (wob == null) continue;
                try {
                    if (VWAdminCommon.isInDelayQueue(wob)) {
                        v_delayWobsList.addElement(woData);
                        continue;
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
                if (this.isInWobsList(wobsList, woData)) continue;
                wobsList.addElement(woData);
            }
            for (i = 0; i < v_delayWobsList.size(); ++i) {
                boolean foundReplacement;
                block14: {
                    foundReplacement = false;
                    Vector v_children = new Vector();
                    try {
                        VWWorkObject wob;
                        int j;
                        VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)v_delayWobsList.elementAt(i);
                        if (this.isInWobsList(wobsList, woData)) continue;
                        if (this.m_tableModel instanceof VWAdminWFByWOInRosterTableModel) {
                            v_children = woData.getChildren();
                        } else {
                            VWWorkObject parentWob = woData.getWob();
                            VWProcess proc = parentWob.fetchProcess();
                            while (proc.hasNext()) {
                                VWWorkObject wob2 = proc.next();
                                if (wob2 == null || wob2.getWorkObjectNumber().equals(parentWob.getWorkObjectNumber())) continue;
                                VWAdminWorkObjectTableData dataField = new VWAdminWorkObjectTableData(wob2, this.m_logonUser, false, -1, -1);
                                v_children.addElement(dataField);
                            }
                        }
                        for (j = 0; j < v_children.size(); ++j) {
                            woData = (VWAdminWorkObjectTableData)v_children.elementAt(j);
                            wob = woData.getWob();
                            if (wob == null || VWAdminCommon.isInDelayQueue(wob) || !wob.getIsTracker() || wob.getParticipantName() == null || VWStringUtils.compare(wob.getParticipantName(), "(NONE)") == 0 || woData.getLockedStatus() != 3) continue;
                            wobsList.addElement(woData);
                            foundReplacement = true;
                            break;
                        }
                        if (foundReplacement) break block14;
                        for (j = 0; j < v_children.size(); ++j) {
                            woData = (VWAdminWorkObjectTableData)v_children.elementAt(j);
                            wob = woData.getWob();
                            if (wob == null || VWAdminCommon.isInDelayQueue(wob) || woData.getLockedStatus() != 3) continue;
                            wobsList.addElement(woData);
                            foundReplacement = true;
                            break;
                        }
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                    }
                }
                if (foundReplacement) continue;
                this.m_vDelayWobsList.addElement(v_delayWobsList.elementAt(i));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return wobsList;
    }

    private void AddRemoveTrackers() {
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        this.RemoveTrackers();
        this.AddTrackers();
    }

    private void AddTrackers() {
        Vector<VWParticipant> vNewTrackers = new Vector<VWParticipant>();
        try {
            if (this.m_selectedTrackers.length == 0) {
                return;
            }
            for (int i = 0; i < this.m_vWorkflows.size(); ++i) {
                if (vNewTrackers != null) {
                    vNewTrackers.removeAllElements();
                }
                VWAdminWorkObjectTableData woData = ((VWAdminDataObjForTrackers)this.m_vWorkflows.elementAt(i)).getWoData();
                VWWorkObject wob = woData.getWob();
                Vector v_trackers = ((VWAdminDataObjForTrackers)this.m_vWorkflows.elementAt(i)).getTrackers();
                for (int j = 0; j < this.m_selectedTrackers.length; ++j) {
                    VWAdminItemInList trackerItem = this.m_selectedTrackers[j];
                    if (trackerItem.isGrayedOut()) continue;
                    VWParticipant tracker = trackerItem.getVWParticipant();
                    boolean bFound = false;
                    for (int k = 0; k < v_trackers.size(); ++k) {
                        VWAdminTrackerDataObject trackerObj = (VWAdminTrackerDataObject)v_trackers.elementAt(k);
                        String name = trackerObj.getTracker().getParticipantName();
                        if (VWStringUtils.compare(name, tracker.getParticipantName()) != 0) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound || this.isTrackerInWorkflow(wob, tracker, vNewTrackers)) continue;
                    vNewTrackers.addElement(tracker);
                }
                if (vNewTrackers.size() == 0) continue;
                VWParticipant[] participantList = new VWParticipant[vNewTrackers.size()];
                for (int index = 0; index < vNewTrackers.size(); ++index) {
                    participantList[index] = (VWParticipant)vNewTrackers.elementAt(index);
                }
                try {
                    boolean bLockedByCurrentUser = false;
                    if (woData.getLockedStatus() == 1) {
                        bLockedByCurrentUser = true;
                    } else {
                        wob.doLock(this.m_bOverride);
                    }
                    wob.setFieldValue("F_Trackers", participantList, false);
                    wob.doSave(true);
                    wob.doRefresh(bLockedByCurrentUser, false);
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
                woData.updateLockedInfo();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void RemoveTrackers() {
        if (this.m_removeTrackersList != null) {
            this.m_removeTrackersList.removeAllElements();
        }
        for (int i = 0; i < this.m_vWorkflows.size(); ++i) {
            Vector v_trackers = ((VWAdminDataObjForTrackers)this.m_vWorkflows.elementAt(i)).getTrackers();
            for (int j = 0; j < v_trackers.size(); ++j) {
                VWAdminWorkObjectTableData woData;
                VWAdminTrackerDataObject trackerInfo = (VWAdminTrackerDataObject)v_trackers.elementAt(j);
                VWAdminItemInList trackerItem = this.findTrackerItem(trackerInfo, this.m_selectedTrackers);
                if (trackerItem != null || this.findTrackerInRemoveList((woData = trackerInfo.getWOData()).getWob(), this.m_removeTrackersList)) continue;
                this.m_removeTrackersList.addElement(woData);
            }
        }
        if (this.m_removeTrackersList.size() != 0) {
            this.doTerminate();
        }
    }

    private void doTerminate() {
        for (int i = 0; i < this.m_removeTrackersList.size(); ++i) {
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_removeTrackersList.elementAt(i);
            VWWorkObject wob = woData.getWob();
            try {
                if (woData.getLockedStatus() != 1) {
                    wob.doLock(this.m_bOverride);
                }
                woData.updateLockedInfo();
                wob.doTerminate();
                if (woData.getRowIndex() < 0) continue;
                woData.setToBeRemoved(true);
                continue;
            }
            catch (Exception ex) {
                VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                this.m_vErrors.addElement(errObj);
                VWDebug.logException(ex);
            }
        }
    }

    private void doSave(Vector wobsList) {
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWException[] arrayExceptions = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_tableModel instanceof VWAdminWOInRosterTableModel) {
            for (int i = 0; i < wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
                if (woData.getLockedStatus() != 1 || !woData.isDirty()) continue;
                VWWorkObject wob = woData.getWob();
                try {
                    wob.doSave(false);
                    wob.doRefresh(true, true);
                    woData.setDirty(false);
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
                woData.updateLockedInfo();
            }
        } else {
            int i;
            int i2;
            for (i2 = 0; i2 < wobsList.size(); ++i2) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i2);
                if (woData.getLockedStatus() != 1 || !woData.isDirty()) continue;
                woVector.addElement(woData.getWob());
            }
            if (woVector.size() != 0) {
                woArray = new VWWorkObject[woVector.size()];
                for (i2 = 0; i2 < woVector.size(); ++i2) {
                    woArray[i2] = (VWWorkObject)woVector.elementAt(i2);
                }
                try {
                    VWWorkObject curWorkObject = woArray[0];
                    arrayExceptions = VWWorkObject.doSaveMany(woArray);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            } else {
                return;
            }
            for (i = 0; i < woArray.length; ++i) {
                VWWorkObject wob = woArray[i];
                try {
                    if (arrayExceptions[i] == null) {
                        wob.doRefresh(true, true);
                        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, wobsList);
                        if (woData == null) continue;
                        woData.setDirty(false);
                        woData.updateLockedInfo();
                        continue;
                    }
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(arrayExceptions[i]);
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (arrayExceptions != null) {
                for (i = 0; i < arrayExceptions.length; ++i) {
                    arrayExceptions[i] = null;
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private void doRefresh(Vector wobsList) {
        VWAdminWorkObjectTableData woData;
        int i;
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWWorkObject wob = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        for (i = 0; i < wobsList.size(); ++i) {
            woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
            if (woData.getLockedStatus() != 1) continue;
            woVector.addElement(woData.getWob());
        }
        if (woVector.size() != 0) {
            woArray = new VWWorkObject[woVector.size()];
            for (i = 0; i < woVector.size(); ++i) {
                woArray[i] = (VWWorkObject)woVector.elementAt(i);
            }
            for (i = 0; i < woArray.length; ++i) {
                try {
                    wob = woArray[i];
                    wob.doRefresh(true, true);
                    woData = VWAdminCommon.findWoData(wob, wobsList);
                    if (woData == null) continue;
                    woData.setDirty(false);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private VWAdminItemInList findTrackerItem(VWAdminTrackerDataObject trackerInfo, VWAdminItemInList[] items) {
        if (trackerInfo == null || items == null) {
            return null;
        }
        String itemName = null;
        try {
            itemName = trackerInfo.getTracker().getParticipantName();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
        for (int i = 0; i < items.length; ++i) {
            VWAdminItemInList trackerItem = items[i];
            String trackerName = trackerItem.getVWParticipant().getParticipantName();
            if (VWStringUtils.compareIgnoreCase(itemName, trackerName) != 0) continue;
            return trackerItem;
        }
        return null;
    }

    private boolean findTrackerInRemoveList(VWWorkObject trackerWob, Vector items) {
        if (trackerWob == null || items == null) {
            return false;
        }
        try {
            String trackerWobId = trackerWob.getWorkObjectNumber();
            for (int i = 0; i < items.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)items.elementAt(i);
                VWWorkObject wob = woData.getWob();
                String wobId = wob.getWorkObjectNumber();
                if (VWStringUtils.compareIgnoreCase(trackerWobId, wobId) != 0) continue;
                return true;
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    private boolean isTrackerInWorkflow(VWWorkObject workflow, VWParticipant tracker, Vector items) {
        try {
            VWProcess proc = workflow.fetchProcess();
            while (proc.hasNext()) {
                VWWorkObject wob = proc.next();
                if (wob == null) continue;
                VWQueue queue = this.m_session.getQueue(wob.getCurrentQueueName());
                if (!wob.getIsTracker() || wob.getParticipantName() == null || VWStringUtils.compare(wob.getParticipantName(), "(NONE)") == 0 || queue.getQueueType() == 3 || VWStringUtils.compare(tracker.getParticipantName(), wob.getParticipantName()) != 0) continue;
                return true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    private boolean checkForSaveAndOverride(int[] rows) {
        boolean bCancel = true;
        boolean bSave = false;
        boolean bLockedByOthers = VWAdminCommon.isAnyLockedByOthers(this.m_wobsList);
        boolean bModified = VWAdminCommon.isAnyWorkModified(this.m_wobsList);
        if (bLockedByOthers || bModified) {
            if (bLockedByOthers && bModified) {
                VWAdminConfirmWithCheckBoxDialog confirmDlg = new VWAdminConfirmWithCheckBoxDialog(this.m_parentFrame, VWResource.s_manageTrackersTitle, VWResource.s_confirmSaveMessageBeforeManageTrackers, VWResource.s_override, 0);
                confirmDlg.setVisible(true);
                if (confirmDlg.isCanceled()) {
                    return bCancel;
                }
                this.m_bOverride = confirmDlg.isChecked();
                bSave = confirmDlg.isYes();
            } else if (bLockedByOthers) {
                VWAdminConfirmYesNoCancelDialog dlg = new VWAdminConfirmYesNoCancelDialog(this.m_parentFrame, VWResource.s_manageTrackersTitle, VWResource.s_confirmOverride, 0);
                dlg.setVisible(true);
                if (dlg.isCanceled()) {
                    return bCancel;
                }
                this.m_bOverride = dlg.isYes();
                bSave = false;
            } else if (bModified) {
                VWAdminConfirmYesNoCancelDialog saveDlg = new VWAdminConfirmYesNoCancelDialog(this.m_parentFrame, VWResource.s_manageTrackersTitle, VWResource.s_confirmSaveMessageBeforeManageTrackers, 0);
                saveDlg.setVisible(true);
                if (saveDlg.isCanceled()) {
                    return bCancel;
                }
                this.m_bOverride = true;
                bSave = saveDlg.isYes();
            }
        } else {
            this.m_bOverride = true;
        }
        if (bSave) {
            this.doSave(this.m_wobsList);
        } else {
            this.doRefresh(this.m_wobsList);
        }
        this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
        if (this.m_vErrors.size() != 0) {
            VWAdminErrorsDialog errorDlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_manageTrackersTitle, VWResource.s_saveRefreshErr, this.m_vErrors);
            errorDlg.setVisible(true);
            return bCancel;
        }
        return false;
    }

    private void removeReferences() {
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_vWorkflows != null) {
            this.m_vWorkflows.removeAllElements();
        }
        if (this.m_vDelayWobsList != null) {
            this.m_vDelayWobsList.removeAllElements();
        }
        if (this.m_wobsList != null) {
            this.m_wobsList.removeAllElements();
        }
        if (this.m_removeTrackersList != null) {
            this.m_removeTrackersList.removeAllElements();
        }
        if (this.m_selectedTrackers != null) {
            for (int i = 0; i < this.m_selectedTrackers.length; ++i) {
                this.m_selectedTrackers[i] = null;
            }
        }
        if (this.m_manageTrackersDialog != null) {
            this.m_manageTrackersDialog.removeReferences();
            this.m_manageTrackersDialog = null;
        }
    }

    private boolean isInWobsList(Vector wobsList, VWAdminWorkObjectTableData woData) {
        boolean found = false;
        for (int i = 0; i < wobsList.size(); ++i) {
            try {
                VWAdminWorkObjectTableData aWoData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
                VWWorkObject wob = aWoData.getWob();
                if (wob == null || !wob.getWorkflowNumber().equals(woData.getWob().getWorkflowNumber())) continue;
                found = true;
                break;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return found;
    }

    private boolean displayErrorMessages() {
        boolean bContinued = false;
        boolean bReturnStat = false;
        if (this.m_vDelayWobsList.size() != 0) {
            if (this.m_wobsList.size() > 0) {
                bContinued = true;
            }
            VWAdminManageTrackerErrorDialog errDlg = new VWAdminManageTrackerErrorDialog(this.m_resultsPane.getParentFrame(), this.m_vDelayWobsList, bContinued);
            errDlg.setVisible(true);
            bReturnStat = errDlg.isYes();
        }
        return bReturnStat;
    }
}

